(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     17076,        438]
NotebookOptionsPosition[     16466,        420]
NotebookOutlinePosition[     16802,        435]
CellTagsIndexPosition[     16759,        432]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"files", "=", 
    RowBox[{"FileNames", "[", "\"\<pars*\>\"", "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Generate", " ", "population", " ", "average", " ", "of", " ", "angular", 
     " ", "velocity"}], ",", " ", 
    RowBox[{
    "angular", " ", "velocity", " ", "variance", " ", "and", " ", "perimeter",
      " ", "variance"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "@", 
     RowBox[{"Reap", "@", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"tardirs", "=", 
          RowBox[{"FileNames", "@", 
           RowBox[{"(", 
            RowBox[{"file", "<>", "\"\</rng*\>\""}], ")"}]}]}], ";", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"result", "=", "\[IndentingNewLine]", 
          RowBox[{"Mean", "@", 
           RowBox[{"First", "@", 
            RowBox[{"Last", "@", 
             RowBox[{"Reap", "@", 
              RowBox[{"Do", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{
                 RowBox[{"Sow", "@", 
                  RowBox[{"Flatten", "@", 
                   RowBox[{"First", "@", 
                    RowBox[{"Last", "@", 
                    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"config", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{"tardir", "<>", "\"\</config.json\>\""}], "]"}]}],
                     ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<SUBSTRATE_ADHESION_POLARIZABILITY\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"ToExpression", "[", 
                    RowBox[{"\"\<STIFFNESS_MEMBRANE\>\"", "/.", 
                    RowBox[{"(", 
                    RowBox[{"\"\<CELL\>\"", "/.", "config"}], ")"}]}], "]"}], 
                    "]"}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/Perimeter\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\"\<Variance\>\"", "+", 
                    RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}], "/.", 
                    "tmp"}], "]"}], ";", "\[IndentingNewLine]", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"Import", "[", 
                    RowBox[{
                    RowBox[{"tardir", "<>", "\"\</Analysis.h5\>\""}], ",", 
                    "\"\</Averages/AngularVelocity_CoM\>\""}], "]"}]}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{"\"\<Mean\>\"", "/.", "tmp"}], "]"}], ";", 
                    "\[IndentingNewLine]", 
                    RowBox[{"Sow", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\"\<Variance\>\"", "+", 
                    RowBox[{"\"\<Mean\>\"", "^", "2"}]}], ")"}], "/.", 
                    "tmp"}], "]"}], ";"}], "\[IndentingNewLine]", 
                    "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", ",", 
                RowBox[{"{", 
                 RowBox[{"tardir", ",", "tardirs"}], "}"}]}], "]"}]}]}]}]}]}],
          ";", "\[IndentingNewLine]", 
         RowBox[{"Sow", "@", "result"}], ";"}], "\[IndentingNewLine]", ",", 
        RowBox[{"{", 
         RowBox[{"file", ",", "files"}], "}"}]}], "]"}]}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"finalresult", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", "4"}], "]"}], "]"}], "-=", 
  RowBox[{
   RowBox[{"finalresult", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "3"}], "]"}], "]"}], "^", 
   "2"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"finalresult", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "6"}], "]"}], "]"}], "-=", 
   RowBox[{
    RowBox[{"finalresult", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "5"}], "]"}], "]"}], "^", "2"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Round", " ", "membrane", " ", "stiffness"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"finalresult", "[", 
     RowBox[{"[", 
      RowBox[{"k", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"1000", "*", 
        RowBox[{"finalresult", "[", 
         RowBox[{"[", 
          RowBox[{"k", ",", "2"}], "]"}], "]"}]}], "]"}], "/", "1000"}], "//",
      "N"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"Length", "@", "finalresult"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.740473733603188*^9, 3.7404737427275352`*^9}, {
   3.7404743487962112`*^9, 3.7404744048960133`*^9}, {3.740474553138999*^9, 
   3.740474576977846*^9}, {3.7404746317376842`*^9, 3.7404747301614637`*^9}, 
   3.7404747631252127`*^9, {3.740474799734309*^9, 3.74047480082445*^9}, {
   3.740475644270343*^9, 3.7404756860640287`*^9}, {3.740475807551002*^9, 
   3.7404759497260637`*^9}, {3.7404782973335257`*^9, 3.740478417250231*^9}, {
   3.7404784807142057`*^9, 3.7404784812280416`*^9}, {3.740562039096106*^9, 
   3.740562116814569*^9}, {3.740562223374802*^9, 3.740562234714262*^9}, {
   3.740562362929048*^9, 3.7405623843951073`*^9}, {3.740562420435128*^9, 
   3.740562658752768*^9}, 3.740563059159471*^9, {3.740563165138597*^9, 
   3.740563168861841*^9}, {3.740563243686219*^9, 3.740563246699719*^9}, {
   3.7405635603605328`*^9, 3.7405636014813633`*^9}, {3.740572893734722*^9, 
   3.74057289796838*^9}, 3.740573734870708*^9, {3.7406397600526047`*^9, 
   3.740639779423215*^9}, {3.740639996821848*^9, 3.740640057971066*^9}, {
   3.740640103630518*^9, 3.7406401046933813`*^9}, {3.740640148469658*^9, 
   3.74064016450458*^9}, {3.7406402223577623`*^9, 3.740640229789052*^9}, {
   3.740640468942174*^9, 3.740640491188933*^9}, 3.7407191473255672`*^9, {
   3.740719183834629*^9, 3.740719184076961*^9}, {3.7407194346455793`*^9, 
   3.7407194535781307`*^9}, {3.740725792331171*^9, 3.7407257958827457`*^9}, {
   3.740725829635138*^9, 3.740725857059944*^9}, {3.740726097172914*^9, 
   3.7407261001087503`*^9}, {3.74072711031215*^9, 3.740727117945513*^9}, {
   3.740727471560315*^9, 3.740727482062001*^9}, {3.7407312439849977`*^9, 
   3.74073125063311*^9}, {3.740731286377161*^9, 3.7407314900148573`*^9}, {
   3.740731742662314*^9, 3.740731747838747*^9}, {3.7407318166911917`*^9, 
   3.7407318175868473`*^9}, {3.740731889782754*^9, 3.7407318966421432`*^9}, {
   3.7407321268142967`*^9, 3.7407321328602667`*^9}, {3.740732258343833*^9, 
   3.7407322689325943`*^9}, {3.74073235640373*^9, 3.740732387789772*^9}, {
   3.740732444405113*^9, 3.7407324458294277`*^9}, {3.740736365662232*^9, 
   3.74073638087253*^9}, {3.740918436092173*^9, 3.740918436274705*^9}, 
   3.740918546605487*^9, {3.740918595432824*^9, 3.740918654134107*^9}, {
   3.740918715753393*^9, 3.740918732746752*^9}, {3.74107805544772*^9, 
   3.741078110742749*^9}, {3.741951907695805*^9, 3.741951924525962*^9}, {
   3.7419670716196747`*^9, 3.7419670791092997`*^9}, {3.7420563768205023`*^9, 
   3.742056397773793*^9}, {3.742665501182191*^9, 3.7426655167970343`*^9}, {
   3.74736414505101*^9, 3.747364145335045*^9}, {3.7473667542430763`*^9, 
   3.74736680210285*^9}, {3.747368654669873*^9, 3.747368654902927*^9}, {
   3.747829733595153*^9, 3.7478297351745777`*^9}, {3.776535088764409*^9, 
   3.776535111739161*^9}, {3.776535175339346*^9, 3.7765351812946587`*^9}, {
   3.776535260608193*^9, 3.776535323842094*^9}, {3.7765354181889563`*^9, 
   3.776535433110038*^9}, {3.776535466183617*^9, 
   3.7765355324697113`*^9}},ExpressionUUID->"4a0e8568-03be-46e1-bbc4-\
f4aa69d21521"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Group", " ", "data", " ", "by", " ", "perimeter", " ", "stiffness"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#1", " ", "specific", " ", "polarizability"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#2", " ", "membrane", " ", "stiffness"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#3", " ", "perimeter", " ", "mean"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#4", " ", "perimeter", " ", "variance"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#5", " ", "angular", " ", "velocity", " ", "mean"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"#6", " ", "angular", " ", "velocity", " ", "variance"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"finalresult", "=", 
     RowBox[{"SortBy", "[", 
      RowBox[{"finalresult", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "&"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0054", "=", 
     RowBox[{"0.054", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0054", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.054"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0057", "=", 
     RowBox[{"0.057", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0057", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.057"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0060", "=", 
     RowBox[{"0.060", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0060", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.060"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0063", "=", 
     RowBox[{"0.063", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0063", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.063"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0066", "=", 
     RowBox[{"0.066", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0066", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.066"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0069", "=", 
     RowBox[{"0.069", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0069", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.069"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0072", "=", 
     RowBox[{"0.072", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0072", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.072"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0075", "=", 
     RowBox[{"0.075", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0075", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.075"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0078", "=", 
     RowBox[{"0.078", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0078", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.078"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"result0081", "=", 
     RowBox[{"0.081", "/.", 
      RowBox[{"GroupBy", "[", 
       RowBox[{"finalresult", ",", 
        RowBox[{
         RowBox[{"#", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"result0081", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "1"}], "]"}], "]"}], "/=", "0.081"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.740796671023196*^9, 3.740796773668927*^9}, {
  3.740798287813002*^9, 3.740798304619738*^9}, {3.74205644053299*^9, 
  3.742056494540193*^9}, {3.742089090974223*^9, 3.742089091682988*^9}, {
  3.776535562119604*^9, 
  3.776535700794672*^9}},ExpressionUUID->"7ba11a5d-2693-4570-a4a4-\
4afc840be4cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Export", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<~/Downloads/thueroffpaper_rot.dat\>\"", ",", 
    RowBox[{"Join", "[", 
     RowBox[{
     "result0054", ",", "result0057", ",", "result0060", ",", "result0063", 
      ",", "result0066", ",", "result0069", ",", "result0072", ",", 
      "result0075", ",", "result0078", ",", "result0081"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.740798527981938*^9, 3.740798603571829*^9}, {
  3.74197750327455*^9, 3.741977504669944*^9}, {3.742056500992178*^9, 
  3.742056503200685*^9}, {3.742089099622164*^9, 3.7420890998018084`*^9}, {
  3.776535717984899*^9, 
  3.776535746329735*^9}},ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-\
f3393780fde3"],

Cell[BoxData["\<\"~/Downloads/thueroffpaper_rot.dat\"\>"], "Output",
 CellChangeTimes->{3.7407985283185463`*^9, 3.7407986056060743`*^9, 
  3.741980861454018*^9, 3.741984223237488*^9, 3.742070777024732*^9, 
  3.742089100489882*^9, 3.753579668421837*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"291d70dc-e9b9-4d87-a7f1-1aea70e285d1"]
}, Open  ]]
},
WindowSize->{808, 755},
WindowMargins->{{46, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 8674, 180, 703, "Input",ExpressionUUID->"4a0e8568-03be-46e1-bbc4-f4aa69d21521"],
Cell[9235, 202, 6052, 188, 598, "Input",ExpressionUUID->"7ba11a5d-2693-4570-a4a4-4afc840be4cc"],
Cell[CellGroupData[{
Cell[15312, 394, 804, 17, 94, "Input",ExpressionUUID->"ae53f5a1-9f52-4e93-9cdf-f3393780fde3"],
Cell[16119, 413, 331, 4, 34, "Output",ExpressionUUID->"291d70dc-e9b9-4d87-a7f1-1aea70e285d1"]
}, Open  ]]
}
]
*)

